require( "HiddenObject/script/style.lua" );

gCurScreen = 0;
yGap = 30;
xGap = 60;

LeftGraphics = {
	"HiddenObject/UI/Button/leftnormal.png",
	"HiddenObject/UI/Button/leftdown.png",
	"HiddenObject/UI/Button/leftover.png",
};	

LeftStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = LeftGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

RightGraphics = {
	"HiddenObject/UI/Button/rightnormal.png",
	"HiddenObject/UI/Button/rightdown.png",
	"HiddenObject/UI/Button/rightover.png",
};	

RightStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = RightGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};



HelpDialogBodyFont2 = {
  standardFont,
  18,
  Color(173,193,161,255)
};

HelpDialogBodyText2 = {
	parent=DefaultStyle,
	font = HelpDialogBodyFont2,
	flags = kVAlignCenter + kHAlignCenter,
	w=kMax,h=40
};

function SetScreen( screen )

	if screen == 1 then
		EnableWindow("helptext1",true)
		EnableWindow("helptext2",false)
		EnableWindow("helptext3",false)
	elseif screen ==2 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",true)
		EnableWindow("helptext3",false)
	elseif screen == 3 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",false)
		EnableWindow("helptext3",true)
	end

	gCurScreen = screen ;
end

HeaderFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  30,
  Color(173,193,161,255)
};

TextStyle=
{
	parent=HelpDialogBodyText2,
	w=320,h=kMax-80
};
function GetWindowX()
	
	x = kCenter;
	if IsMainMenu() then x = 310; end
	return x;
end

function GetWindowY()
	
	y = kCenter - 45;
	if IsMainMenu() then y = 115; end
	return y;
end


MakeDialog
{
	-- Name the modal dialog
	name="help",
	Bitmap
	{
		image="HiddenObject/UI/HelpWindow/background",
		x=GetWindowX(),
		y=GetWindowY(),

		Window
		{
			name="helptext1",
			w=kMax,h=kMax,

			SetStyle(HelpDialogBodyText2),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "concentration",
				font = StandardHeaderFont,
				h = 40,
			};
		
			SetStyle(TextStyle),
			Text
			{
				label="concentrationhelp1",
				flags = kHAlignCenter ,
				x = 50,
				y = 70,
			},

			SetStyle(LeftStyle),
			Button
			{
				label="close",
				name="close",
				font = StandardButtonFont,
				align=kHAlignLeft+kVAlignBottom,
				x=xGap,y=kMax-yGap,
				command=function() CloseWindow(); end;
			},
			SetStyle(RightStyle),
			Button
			{
				label="next",
				name="next",
				font = StandardButtonFont,
				align=kHAlignRight+kVAlignBottom,
				x=kMax-xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen+1 ); end;
			}
		},
		Window
		{
			name="helptext2",
			w=kMax,h=kMax,

			SetStyle(HelpDialogBodyText2),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "concentration",
				font = StandardHeaderFont,
				h = 40,
			};
			
			SetStyle(TextStyle),
			Text
			{
				label="concentrationhelp2",
				flags = kHAlignCenter ,
				x = 50,
				y = 70,
			},
			SetStyle(LeftStyle),
			Button
			{
				label="back",
				name="back",
				font = StandardButtonFont,
				align=kHAlignLeft+kVAlignBottom,
				x=xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen-1 ); end;
			},
			SetStyle(RightStyle),
			Button
			{
				label="next",
				name="next",
				font = StandardButtonFont,
				align=kHAlignRight+kVAlignBottom,
				x=kMax-xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen+1 ); end;
			}
		},
		Window
		{
			name="helptext3",
			w=kMax,h=kMax,

			SetStyle(HelpDialogBodyText2),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "concentration",
				font = StandardHeaderFont,
				h = 40,
			};
			
			SetStyle(TextStyle),
			Text
			{
				label="concentrationhelp3",
				flags = kHAlignCenter ,
				x = 50,
				y = 70,
			},
			SetStyle(LeftStyle),
			Button
			{
				label="back",
				name="back",
				font = StandardButtonFont,
				align=kHAlignLeft+kVAlignBottom,
				x=xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen-1 ); end;
			},
			SetStyle(RightStyle),
			Button
			{
				label="close",
				name="close",
				font = StandardButtonFont,
				align=kHAlignRight+kVAlignBottom,
				x=kMax-xGap,y=kMax-yGap,
				command=function() CloseWindow(); end;
			}
		}
	}
}

SetScreen(1);
